package parser;

/**
 * Left parenthesis token class.
 */
public class LeftPToken extends AToken {
    /**
     * Interface for a visitor to visit a left parenthesis token.
     */
    public static interface ILeftPVisitor extends ITokVisitor {
        /**
         * Case for a left parenthesis token.
         *
         * @param host  left parenthesis token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object leftPCase(LeftPToken host, Object param);
    }

    /**
     * Singleton instance.
     */
    public final static LeftPToken Singleton = new LeftPToken();

    /**
     * Private singleton constructor.
     */
    private LeftPToken() {
        super("(");
    }

    /**
     * Execute the left parenthesis case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public Object execute(ITokVisitor algo, Object param) {
        return (algo instanceof ILeftPVisitor) ?
               ((ILeftPVisitor) algo).leftPCase(this, param) :
               algo.defaultCase(this, param);
    }
}

